/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import java.util.ArrayList;
import roguelike.Element;
import roguelike.MapManager;
import roguelike.Unit;

public class Enemy
extends Unit {
    protected MapManager map;
    public EnemyType enemyType;
    public boolean deathrattleAvailable = true;

    public static Enemy getEnemy(MapManager map, EnemyType type) {
        if (type == EnemyType.Chest) {
            return new EnemyChest(map);
        }
        return new Enemy(map, type);
    }

    private Enemy(MapManager map, EnemyType type) {
        super(Element.ElementType.kTypeEnemy);
        this.enemyType = type;
        switch (this.enemyType) {
            case Treefolk: {
                this.setImage("enemy_treefolk.png");
                this.lives = 4;
                this.drawDeltaX = 5;
                break;
            }
            case Ooze: {
                this.setImage("enemy_red_ooze.png");
                this.lives = 2;
                break;
            }
            case Shroom: {
                this.setImage("enemy_shroom.png");
                this.lives = 2;
                break;
            }
            case Snail: {
                this.setImage("enemy_snail.png");
                this.lives = 2;
            }
        }
        this.map = map;
    }

    public void move() {
        if (this.rootCount > 0) {
            --this.rootCount;
            return;
        }
        int[] dir = this.getOptimalDirection(MovePriority.GetCloser);
        int[] nextPos = new int[]{(int)this.nextPosX + dir[0], (int)this.nextPosY + dir[1]};
        if (this.map.getHero().getSlot()[0] == nextPos[0] && this.map.getHero().getSlot()[1] == nextPos[1]) {
            this.map.hitHero(this.getName());
            this.tackleDestination = new float[]{this.getSlot()[0] + dir[0], this.getSlot()[1] + dir[1]};
        } else if (dir[0] != 0 || dir[1] != 0) {
            if (this.enemyType == EnemyType.Treefolk) {
                return;
            }
            this.map.elementMoving(this.getSlot(), nextPos);
            super.moveTo(nextPos);
        }
    }

    protected int[] getOptimalDirection(MovePriority priority) {
        int[] deltaPos;
        int w = 3;
        int h = 3;
        int x_i = this.map.getHero().getSlot()[0];
        int y_i = this.map.getHero().getSlot()[1];
        int x_f = this.getSlot()[0];
        int y_f = this.getSlot()[1];
        int[] current = new int[]{x_i, y_i};
        int x = current[0];
        int y = current[1];
        int[][] costos = new int[w][h];
        NodeStatus[][] status = new NodeStatus[w][h];
        int max = 2 * w * h;
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                status[i][j] = NodeStatus.Unvisited;
                costos[i][j] = max;
                ++j;
            }
            ++i;
        }
        ArrayList<int[]> abiertos = new ArrayList<int[]>();
        abiertos.add(new int[]{x, y});
        costos[x][y] = 0;
        while ((x != x_f || y != y_f) && abiertos.size() > 0) {
            status[current[0]][current[1]] = NodeStatus.Closed;
            int i2 = 0;
            while (i2 < abiertos.size()) {
                if (((int[])abiertos.get(i2))[0] == x && ((int[])abiertos.get(i2))[1] == y) {
                    abiertos.remove(i2);
                    break;
                }
                ++i2;
            }
            if (x > 0 && (this.map.isSlotAvailable(x - 1, y) || x - 1 == x_f && y == y_f) && status[x - 1][y] != NodeStatus.Closed) {
                status[x - 1][y] = NodeStatus.Opened;
                abiertos.add(new int[]{x - 1, y});
                costos[x - 1][y] = costos[x][y] + 1;
            }
            if (x + 1 < w && (this.map.isSlotAvailable(x + 1, y) || x + 1 == x_f && y == y_f) && status[x + 1][y] != NodeStatus.Closed) {
                status[x + 1][y] = NodeStatus.Opened;
                abiertos.add(new int[]{x + 1, y});
                costos[x + 1][y] = costos[x][y] + 1;
            }
            if (y > 0 && (this.map.isSlotAvailable(x, y - 1) || y - 1 == y_f && x == x_f) && status[x][y - 1] != NodeStatus.Closed) {
                status[x][y - 1] = NodeStatus.Opened;
                abiertos.add(new int[]{x, y - 1});
                costos[x][y - 1] = costos[x][y] + 1;
            }
            if (y + 1 < h && (this.map.isSlotAvailable(x, y + 1) || y + 1 == y_f && x == x_f) && status[x][y + 1] != NodeStatus.Closed) {
                status[x][y + 1] = NodeStatus.Opened;
                abiertos.add(new int[]{x, y + 1});
                costos[x][y + 1] = costos[x][y] + 1;
            }
            int min = Integer.MAX_VALUE;
            int i3 = 0;
            while (i3 < abiertos.size()) {
                int[] temp = (int[])abiertos.get(i3);
                if (costos[temp[0]][temp[1]] < min) {
                    min = costos[temp[0]][temp[1]];
                    current = temp;
                }
                ++i3;
            }
            x = current[0];
            y = current[1];
        }
        int[] a = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
        if (x_f > 0 && this.map.isSlotAvailable(x_f - 1, y_f)) {
            a[0] = costos[x_f - 1][y_f];
        }
        if (x_f + 1 < w && this.map.isSlotAvailable(x_f + 1, y_f)) {
            a[1] = costos[x_f + 1][y_f];
        }
        if (y_f > 0 && this.map.isSlotAvailable(x_f, y_f - 1)) {
            a[2] = costos[x_f][y_f - 1];
        }
        if (y_f + 1 < h && this.map.isSlotAvailable(x_f, y_f + 1)) {
            a[3] = costos[x_f][y_f + 1];
        }
        if (a[0] > max && a[1] > max && a[2] > max && a[3] > max) {
            return new int[2];
        }
        int min = 2 * max;
        int index = -1;
        boolean horizontalMinimizes = Math.abs(y_f - y_i) < Math.abs(x_f - x_i);
        boolean verticalMinimizes = Math.abs(x_f - x_i) < Math.abs(y_f - y_i);
        int i4 = 0;
        while (i4 < 4) {
            if (a[i4] < min || a[i4] == min && (!horizontalMinimizes && !verticalMinimizes && Math.floor(Math.random() * 2.0) == 0.0 || priority == MovePriority.GetCloser && (verticalMinimizes && i4 >= 2 || horizontalMinimizes && i4 < 2) || priority == MovePriority.GetAligned && (verticalMinimizes && i4 < 2 || horizontalMinimizes && i4 >= 2))) {
                min = a[i4];
                index = i4;
            }
            ++i4;
        }
        if (index == 0) {
            int[] nArray = new int[2];
            nArray[0] = -1;
            deltaPos = nArray;
        } else if (index == 1) {
            int[] nArray = new int[2];
            nArray[0] = 1;
            deltaPos = nArray;
        } else if (index == 2) {
            int[] nArray = new int[2];
            nArray[1] = -1;
            deltaPos = nArray;
        } else {
            int[] nArray = new int[2];
            nArray[1] = 1;
            deltaPos = nArray;
        }
        return deltaPos;
    }

    public boolean shouldDrawHP() {
        return !(this instanceof EnemyChest) || !((EnemyChest)this).sleeping;
    }

    public String getName() {
        switch (this.enemyType) {
            case Treefolk: {
                return "Treefolk";
            }
            case Ooze: {
                return "Ooze";
            }
            case Shroom: {
                return "Shroom";
            }
            case Snail: {
                return "Snail";
            }
        }
        return "";
    }

    @Override
    public String getDescription() {
        switch (this.enemyType) {
            case Treefolk: {
                return "Treefolk: doesn't move";
            }
            case Ooze: {
                return "Ooze: gives +1 hp to a random monster when killed";
            }
            case Shroom: {
                return "Shroom: silences you for 2 turns when killed";
            }
            case Snail: {
                return "Snail: roots you for 1 turn when killed";
            }
        }
        return "";
    }

    /* synthetic */ Enemy(MapManager mapManager, EnemyType enemyType, Enemy enemy) {
        this(mapManager, enemyType);
    }

    private static class EnemyChest
    extends Enemy {
        public boolean sleeping = true;

        public EnemyChest(MapManager map) {
            super(map, EnemyType.Chest, null);
            this.setImage("obj_chest.png");
            this.lives = 3;
        }

        @Override
        public void move() {
            if (this.sleeping) {
                return;
            }
            super.move();
        }

        @Override
        public void takeHit(int ad) {
            super.takeHit(ad);
            this.sleeping = false;
            this.setImage("enemy_chest.png");
        }

        @Override
        public String getDescription() {
            if (this.sleeping) {
                return "Chest: holds a treasure";
            }
            return "Mimic: instead of score it holds a treasure";
        }

        @Override
        public String getName() {
            if (this.sleeping) {
                return "Chest";
            }
            return "Mimic";
        }
    }

    public static enum EnemyType {
        Treefolk,
        Ooze,
        Shroom,
        Snail,
        Chest;

    }

    public static enum MovePriority {
        GetCloser,
        GetAligned;

    }

    public static enum NodeStatus {
        Opened,
        Closed,
        Unvisited;

    }
}

