/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Map;
import roguelike.ChoiceDialogue;
import roguelike.Cosmetic;
import roguelike.DSprite;
import roguelike.Element;
import roguelike.Enemy;
import roguelike.Global;
import roguelike.Hero;
import roguelike.Item;
import roguelike.MapManager;
import roguelike.Projectile;
import roguelike.ScoreSoul;
import roguelike.SoundManager;
import roguelike.Trap;
import roguelike.WaveManager;

public class GameModel
implements MapManager {
    private Hero hero;
    private DSprite portal;
    public ArrayList<Enemy> enemies;
    private ArrayList<Element> statics;
    private ArrayList<Projectile> projectiles;
    private ArrayList<Cosmetic> cosmetics;
    private ArrayList<ScoreSoul> souls;
    private Trap trap;
    private ArrayList<Enemy> daggerTargets;
    public int[] markPosition;
    private ArrayList<int[]> allSlots;
    public int[][] tileColor;
    private float blockTime;
    private boolean blocked;
    private float enemyTurnTimer;
    private float firePunchTimer;
    private float tigerSlashTimer;
    private float tigerSlashCounter;
    private float treasureTimer;
    private int currentLevel;
    private static final int ADVANCING_NOT = 0;
    private static final int ADVANCING_DISMISSING = 1;
    private static final int ADVANCING_PRESENTING = 2;
    private int advanceLevelStatus = 2;
    private int boardDeltaY;
    public String killer;
    private Enemy target;
    public ChoiceDialogue dialogue = new ChoiceDialogue();
    public boolean passTurnAfterDialogue;
    private boolean enemiesDidMove;
    public boolean secretLevel;
    public boolean chestIsFromSecretLevel = false;

    public GameModel() {
        WaveManager.getSharedManager().randomizeRun();
        this.hero = new Hero();
        this.portal = new DSprite("obj_gate.png");
        int[] nArray = new int[2];
        nArray[1] = 15;
        this.portal.setDrawDelta(nArray);
        this.tileColor = new int[3][3];
        this.enemies = new ArrayList();
        this.statics = new ArrayList();
        this.projectiles = new ArrayList();
        this.cosmetics = new ArrayList();
        this.souls = new ArrayList();
        this.daggerTargets = new ArrayList();
        this.allSlots = new ArrayList();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.allSlots.add(new int[]{i, j++});
            }
            ++i;
        }
        this.currentLevel = 0;
        this.advanceLevel();
    }

    public void update(float dt) {
        boolean bl;
        if (this.dialogue.visible) {
            return;
        }
        if (this.firePunchTimer > 0.0f) {
            this.firePunchTimer -= dt;
            if (this.firePunchTimer <= 0.0f) {
                ArrayList<Enemy> burnEnem = this.getAdjacentEnemies((int)this.target.positionX, (int)this.target.positionY);
                burnEnem.add(this.target);
                for (Enemy e : burnEnem) {
                    e.takeHit(1);
                    Cosmetic cosmetic = new Cosmetic("obj_fire.png");
                    cosmetic.setPosition(e.getPosition());
                    cosmetic.timer = 0.2f;
                    this.cosmetics.add(cosmetic);
                }
                this.blocked = false;
                this.passTurn(0.16f, 0.16f);
            }
        }
        if (this.tigerSlashCounter > 0.0f) {
            this.tigerSlashTimer -= dt;
            if (this.tigerSlashTimer <= 0.0f) {
                this.tigerSlashCounter -= 1.0f;
                this.tigerSlashTimer = 0.5f;
                this.blockTime = 1.0f;
                int ad = this.hero.ad;
                if (this.enemies.size() <= 2 && this.hero.hasItemOfType(Item.ItemType.ItemSword)) {
                    ++ad;
                }
                if ((this.target.enemyType == Enemy.EnemyType.Treefolk || this.target.enemyType == Enemy.EnemyType.Chest) && this.hero.hasItemOfType(Item.ItemType.ItemAxe)) {
                    ad += 2;
                }
                if (this.hero.hasItemOfType(Item.ItemType.ItemDivineRapier)) {
                    ++ad;
                }
                this.target.takeHit(ad);
                this.hero.addHitStack();
                Cosmetic slash = new Cosmetic("obj_slash.png");
                slash.setPosition(this.target.getPosition());
                slash.timer = 0.2f;
                this.cosmetics.add(slash);
                if (this.target.lives <= 0 || this.tigerSlashCounter == 0.0f) {
                    this.tigerSlashCounter = 0.0f;
                    if (this.target.enemyType == Enemy.EnemyType.Chest && this.target.lives <= 0) {
                        this.passTurnAfterDialogue = true;
                    } else {
                        this.blocked = false;
                        this.passTurn(0.16f, 0.16f);
                    }
                }
            }
        }
        if (this.treasureTimer > 0.0f) {
            this.treasureTimer -= dt;
            if (this.treasureTimer <= 0.0f) {
                if (this.chestIsFromSecretLevel) {
                    this.dialogue.items.clear();
                    if (this.hero.items.size() < 3) {
                        this.dialogue.items.add(new Item(Item.ItemType.ItemDivineRapier));
                        this.dialogue.items.add(new Item(Item.ItemType.ItemDivineRapier));
                        this.dialogue.items.add(new Item(Item.ItemType.ItemDivineRapier));
                    } else {
                        this.dialogue.items.add(new Item(Item.ItemType.ItemMaxStar));
                        this.dialogue.items.add(new Item(Item.ItemType.ItemMaxStar));
                        this.dialogue.items.add(new Item(Item.ItemType.ItemMaxStar));
                    }
                } else if (this.hero.items.size() >= 3) {
                    this.dialogue.items.clear();
                    this.dialogue.items.add(new Item(Item.ItemType.ItemHeal));
                    this.dialogue.items.add(new Item(Item.ItemType.ItemEnergize));
                    this.dialogue.items.add(new Item(Item.ItemType.ItemScore));
                    this.dialogue.items.add(new Item(Item.ItemType.ItemAttack));
                    while (this.dialogue.items.size() > 3) {
                        this.dialogue.items.remove((int)(Math.random() * (double)this.dialogue.items.size()));
                    }
                }
                this.dialogue.visible = true;
            }
        }
        if (this.blockTime > 0.0f) {
            this.blockTime -= dt;
        }
        if (this.enemyTurnTimer > 0.0f) {
            this.enemyTurnTimer -= dt;
            if (this.enemyTurnTimer <= 0.0f) {
                if (this.projectiles.size() > 0) {
                    this.enemyTurnTimer = 0.001f;
                } else {
                    this.startEnemyTurn();
                    this.moveEnemies();
                    this.randomizeMark();
                }
            }
        }
        if (this.advanceLevelStatus != 0) {
            this.boardDeltaY = (int)((float)this.boardDeltaY + 1200.0f * dt);
            if (this.advanceLevelStatus == 1 && this.boardDeltaY >= 600) {
                this.advanceLevel();
            } else if (this.advanceLevelStatus == 2 && this.boardDeltaY > 0) {
                this.boardDeltaY = 0;
                this.advanceLevelStatus = 0;
            }
        }
        this.hero.update(dt);
        Element elem = this.getElementAt(this.hero.getSlot()[0], this.hero.getSlot()[1]);
        if (elem != null && elem.type == Element.ElementType.kTypeSoul) {
            this.statics.remove(elem);
        }
        ArrayList<DSprite> toRemove = new ArrayList<DSprite>();
        ArrayList<int[]> dyingOozePositions = new ArrayList<int[]>();
        for (Enemy enemy : this.enemies) {
            enemy.update(dt);
            if (!enemy.shouldRemove()) continue;
            if (this.hero.hasItemOfType(Item.ItemType.ItemVampiricNecklace)) {
                this.hero.addLife(1);
            }
            if (this.hero.hasItemOfType(Item.ItemType.ItemSelenicNecklace)) {
                this.hero.addMana(1);
            }
            int instantScore = 0;
            if (this.hero.hasItemOfType(Item.ItemType.ItemGreenTalisman) && this.hero.silenceCounter > 0) {
                instantScore = 3;
            }
            if (this.hero.hasItemOfType(Item.ItemType.ItemDivineRapier)) {
                instantScore += 2;
            }
            if (enemy.deathrattleAvailable) {
                if (enemy.enemyType == Enemy.EnemyType.Shroom) {
                    this.hero.silenceCounter = 2;
                } else if (enemy.enemyType == Enemy.EnemyType.Snail) {
                    ++this.hero.rootCount;
                } else if (enemy.enemyType == Enemy.EnemyType.Ooze) {
                    dyingOozePositions.add(enemy.getSlot());
                } else if (enemy.enemyType == Enemy.EnemyType.Chest) {
                    this.chestIsFromSecretLevel = this.secretLevel;
                    this.dialogue.selectedItem = 0;
                    this.treasureTimer = 0.2f;
                    this.blockTime += 0.5f;
                }
            }
            if (enemy.enemyType != Enemy.EnemyType.Chest) {
                if (this.hero.currentForm == 0) {
                    instantScore += 3;
                } else {
                    ArrayList<ScoreSoul> souls = this.getSoulsAt((int)enemy.positionX, (int)enemy.positionY);
                    int i = souls.size();
                    while (i < souls.size() + 2) {
                        ScoreSoul soul = new ScoreSoul();
                        soul.lives = i + 1;
                        soul.setPosition(enemy.getPosition());
                        soul.setDrawDelta(new int[]{-15 + 35 * (i % 2), -20 + 40 * (i / 2)});
                        this.souls.add(soul);
                        ++i;
                    }
                }
            }
            if (instantScore > 0) {
                this.hero.score += instantScore;
                Cosmetic score = new Cosmetic("ic_score_" + instantScore + ".png");
                score.setPosition(enemy.getPosition());
                score.timer = 0.4f;
                this.cosmetics.add(score);
            }
            this.hero.transformAvailable = true;
            toRemove.add(enemy);
        }
        for (Object e : toRemove) {
            this.enemies.remove(e);
        }
        if (this.enemies.size() > 0) {
            for (int[] nArray : dyingOozePositions) {
                Enemy target = this.enemies.get((int)(Math.random() * (double)this.enemies.size()));
                Projectile heal = new Projectile(Projectile.ProjectileType.OozeHeal, true, target);
                heal.setPosition(new float[]{nArray[0], nArray[1]});
                this.projectiles.add(heal);
            }
        }
        boolean bl2 = false;
        for (Projectile projectile : this.projectiles) {
            projectile.update(dt);
            if (projectile.shouldRemove()) {
                toRemove.add(projectile);
                bl = true;
                continue;
            }
            if (!projectile.isActive()) continue;
            if (!projectile.isFriendly()) {
                this.blockTime = 0.05f;
            }
            if (!this.isValidSlot(projectile.getPosition()[0], projectile.getPosition()[1])) {
                projectile.fadeOut(false);
                continue;
            }
            if (projectile.isFriendly()) {
                if (!(Point.distance(projectile.target.positionX, projectile.target.positionY, projectile.getPosition()[0], projectile.getPosition()[1]) < 0.5)) continue;
                if (projectile.type == Projectile.ProjectileType.DarkDagger) {
                    projectile.target.takeHit(1);
                } else {
                    ++projectile.target.lives;
                }
                projectile.fadeOut(true);
                continue;
            }
            if (!(Point.distance(this.hero.getSlot()[0], this.hero.getSlot()[1], projectile.getPosition()[0], projectile.getPosition()[1]) < 0.5)) continue;
            this.hitHero("Projectile");
            projectile.fadeOut(true);
        }
        for (Projectile projectile : toRemove) {
            this.projectiles.remove(projectile);
        }
        if (bl && this.daggerTargets.size() > 0) {
            this.throwDagger();
        }
        for (Cosmetic cosmetic : this.cosmetics) {
            cosmetic.timer -= dt;
            if (!(cosmetic.timer <= 0.0f)) continue;
            toRemove.add(cosmetic);
        }
        for (DSprite dSprite : toRemove) {
            this.cosmetics.remove(dSprite);
        }
        for (ScoreSoul scoreSoul : this.souls) {
            if (scoreSoul.lives > 0) continue;
            toRemove.add(scoreSoul);
        }
        for (DSprite dSprite : toRemove) {
            this.souls.remove(dSprite);
        }
        this.checkSecretLevel();
    }

    public void moveHero(int dir) {
        if (this.dialogue.visible) {
            int dItem = 0;
            if (dir == 2 && this.dialogue.selectedItem < 2) {
                dItem = 1;
            } else if (dir == 0 && this.dialogue.selectedItem > 0) {
                dItem = -1;
            }
            this.dialogue.selectedItem += dItem;
            return;
        }
        if (this.blockTime > 0.0f || this.projectiles.size() > 0 || this.blocked) {
            return;
        }
        boolean canMove = true;
        if (this.hero.rootCount > 0) {
            --this.hero.rootCount;
            if (this.hero.currentForm == 1 && this.hero.attackIDs.size() > 0) {
                canMove = false;
            } else {
                this.passTurn(0.16f, 0.16f);
                return;
            }
        }
        int nextPosX = this.hero.getSlot()[0];
        int nextPosY = this.hero.getSlot()[1];
        int[] d = Global.getVectorFromDir(dir);
        Element e = this.getElementAt(nextPosX += d[0], nextPosY += d[1]);
        if (e != null && e.type == Element.ElementType.kTypeEnemy) {
            int ad = this.hero.ad + this.hero.tempAD;
            this.hero.tempAD = 0;
            if (this.enemies.size() <= 2 && this.hero.hasItemOfType(Item.ItemType.ItemSword)) {
                ++ad;
            }
            if ((((Enemy)e).enemyType == Enemy.EnemyType.Treefolk || ((Enemy)e).enemyType == Enemy.EnemyType.Chest) && this.hero.hasItemOfType(Item.ItemType.ItemAxe)) {
                ad += 2;
            }
            if (this.hero.hasItemOfType(Item.ItemType.ItemDivineRapier)) {
                ++ad;
            }
            Enemy enemy = (Enemy)e;
            this.hero.tackle(dir);
            boolean killedWithTackle = false;
            enemy.takeHit(ad);
            if (this.hero.attackIDs.size() == 0) {
                if (enemy.lives <= 0) {
                    killedWithTackle = true;
                    if (enemy.enemyType != Enemy.EnemyType.Chest) {
                        this.passTurn(0.16f, 0.16f);
                    } else {
                        this.passTurnAfterDialogue = true;
                    }
                } else {
                    this.passTurn(0.16f, 0.16f);
                }
            } else {
                String attackID = this.hero.attackIDs.get(0);
                this.hero.attackIDs.remove(0);
                if (attackID.equals("Q")) {
                    enemy.rootCount = 2;
                } else if (attackID.equals("W")) {
                    if (enemy.lives > 0) {
                        this.target = enemy;
                        this.tigerSlashCounter = 2.0f;
                        this.tigerSlashTimer = 0.5f;
                        this.blocked = true;
                    } else {
                        killedWithTackle = true;
                        if (enemy.enemyType != Enemy.EnemyType.Chest) {
                            this.passTurn(0.16f, 0.16f);
                        } else {
                            this.passTurnAfterDialogue = true;
                        }
                    }
                } else if (attackID.equals("E")) {
                    this.target = enemy;
                    this.firePunchTimer = 0.5f;
                    this.blocked = true;
                    Cosmetic fire = new Cosmetic("obj_fire.png");
                    fire.setPosition(this.target.getPosition());
                    fire.timer = 0.2f;
                    this.cosmetics.add(fire);
                    if (enemy.lives <= 0) {
                        killedWithTackle = true;
                    }
                }
            }
            if (killedWithTackle && this.hero.hasItemOfType(Item.ItemType.ItemHourglass)) {
                this.hero.invulnerable = true;
            }
            if (this.hero.currentForm == 1) {
                this.hero.addHitStack();
            }
        } else {
            if (!canMove) {
                this.passTurn(0.16f, 0.16f);
                return;
            }
            if (!this.isValidSlot(nextPosX, nextPosY)) {
                canMove = false;
            }
            if (e != null && e.getType() != Element.ElementType.kTypeSoul) {
                canMove = false;
            }
            if (canMove) {
                this.elementMoving(this.hero.getSlot(), new int[]{nextPosX, nextPosY});
                this.hero.moveTo(nextPosX, nextPosY);
                this.catchSouls();
                if (this.hero.attackIDs.size() > 0 && this.hero.attackIDs.get(0).equals("Q")) {
                    this.hero.attackIDs.remove(0);
                    this.checkTrap(false);
                } else {
                    this.passTurn(0.25f, 0.15f);
                }
            } else if ((float)nextPosX == this.portal.getPosition()[0] && (float)nextPosY == this.portal.getPosition()[1]) {
                this.hero.moveTo(nextPosX, nextPosY);
                this.advanceLevelStatus = 1;
                return;
            }
        }
    }

    private void catchSouls() {
        ArrayList<ScoreSoul> souls = this.getSoulsAt((int)this.hero.nextPosX, (int)this.hero.nextPosY);
        for (ScoreSoul s : souls) {
            ++this.hero.score;
            s.lives = 0;
        }
    }

    private ArrayList<ScoreSoul> getSoulsAt(int x, int y) {
        ArrayList<ScoreSoul> ret = new ArrayList<ScoreSoul>();
        for (ScoreSoul s : this.souls) {
            if (s.positionX != (float)x || s.positionY != (float)y) continue;
            ret.add(s);
        }
        return ret;
    }

    private void moveEnemies() {
        if (this.enemies.size() == 0) {
            return;
        }
        ArrayList enemiesCopy = (ArrayList)this.enemies.clone();
        this.enemies.clear();
        while (enemiesCopy.size() > 0) {
            Enemy e = (Enemy)enemiesCopy.get((int)(Math.random() * (double)enemiesCopy.size()));
            enemiesCopy.remove(e);
            this.enemies.add(e);
        }
        this.hero.hpLostThisTurn = 0;
        for (Enemy e : this.enemies) {
            e.move();
        }
        this.hero.invulnerable = false;
        this.enemiesDidMove = true;
    }

    public void castSpell(char keyChar) {
        float blockTime;
        if (this.blockTime > 0.0f || this.blocked || this.projectiles.size() > 0) {
            return;
        }
        boolean success = false;
        Item itemToUse = null;
        if (keyChar == '1' && this.hero.items.get(0).isUsable()) {
            itemToUse = this.hero.items.get(0);
        } else if (keyChar == '2' && this.hero.items.get(1).isUsable()) {
            itemToUse = this.hero.items.get(1);
        } else if (keyChar == '3' && this.hero.items.get(2).isUsable()) {
            itemToUse = this.hero.items.get(2);
        }
        if (itemToUse != null) {
            --itemToUse.nCharges;
            if (itemToUse.nCharges <= 0) {
                this.hero.items.remove(itemToUse);
            }
            switch (itemToUse.type) {
                case ItemBrownPot: {
                    ArrayList<Integer> spellsOnCooldown = new ArrayList<Integer>();
                    if (!this.hero.beastQAvailable) {
                        spellsOnCooldown.add(0);
                    }
                    if (!this.hero.beastWAvailable) {
                        spellsOnCooldown.add(1);
                    }
                    if (!this.hero.beastEAvailable) {
                        spellsOnCooldown.add(2);
                    }
                    if (spellsOnCooldown.size() <= 0) break;
                    int randSpell = (Integer)spellsOnCooldown.get((int)(Math.random() * (double)spellsOnCooldown.size()));
                    if (randSpell == 0) {
                        this.hero.beastQAvailable = true;
                        break;
                    }
                    if (randSpell == 1) {
                        this.hero.beastWAvailable = true;
                        break;
                    }
                    if (randSpell != 2) break;
                    this.hero.beastEAvailable = true;
                    break;
                }
                case ItemPurplePot: {
                    ++this.hero.ad;
                    break;
                }
                case ItemGreenPot: {
                    this.hero.silenceCounter = 0;
                    this.hero.rootCount = 0;
                    break;
                }
                case ItemTruesightWard: {
                    this.hero.tempAD = 2;
                }
            }
        }
        if (this.hero.silenceCounter > 0) {
            return;
        }
        if (this.hero.currentForm == 0) {
            boolean usedMana = false;
            int deltaMana = 0;
            if (this.hero.hasItemOfType(Item.ItemType.ItemDivineRapier)) {
                deltaMana = 1;
            }
            if (keyChar == 'Q' && this.hero.mana >= 4 - deltaMana && this.enemies.size() > 0) {
                success = true;
                usedMana = true;
                this.hero.mana -= 4 - deltaMana;
                this.daggerTargets.addAll(this.enemies);
                while (this.daggerTargets.size() > 3) {
                    int minLives = 100;
                    Enemy toRemove = this.daggerTargets.get(0);
                    for (Enemy e : this.daggerTargets) {
                        if (e.lives >= minLives) continue;
                        minLives = e.lives;
                        toRemove = e;
                    }
                    this.daggerTargets.remove(toRemove);
                }
                Enemy rep = this.daggerTargets.get(0);
                if (this.daggerTargets.size() > 1 && this.daggerTargets.get((int)1).lives > rep.lives) {
                    rep = this.daggerTargets.get(1);
                }
                if (this.daggerTargets.size() > 2 && this.daggerTargets.get((int)2).lives > rep.lives) {
                    rep = this.daggerTargets.get(2);
                }
                this.daggerTargets.remove(rep);
                this.daggerTargets.add(rep);
                this.daggerTargets.add(rep);
                this.daggerTargets.add(rep);
                this.throwDagger();
            } else if (keyChar == 'W' && this.hero.mana >= 3 - deltaMana) {
                success = true;
                usedMana = true;
                this.hero.mana -= 3 - deltaMana;
                this.hero.teleportTo(this.markPosition);
                ArrayList<Enemy> enemies = this.getAdjacentEnemies((int)this.hero.positionX, (int)this.hero.positionY);
                for (Enemy e : enemies) {
                    e.rootCount = 2;
                    e.takeHit(1);
                }
                this.randomizeMark();
                this.catchSouls();
                this.checkTrap(false);
            } else if (keyChar == 'E' && this.hero.mana >= 4 - deltaMana) {
                success = true;
                usedMana = true;
                this.hero.mana -= 4 - deltaMana;
                ArrayList<int[]> positions = new ArrayList<int[]>();
                positions.add(new int[]{(int)this.hero.positionX, (int)this.hero.positionY + 1});
                positions.add(new int[]{(int)this.hero.positionX, (int)this.hero.positionY + 2});
                positions.add(new int[]{(int)this.hero.positionX, (int)this.hero.positionY - 1});
                positions.add(new int[]{(int)this.hero.positionX, (int)this.hero.positionY - 2});
                positions.add(new int[]{(int)this.hero.positionX + 1, (int)this.hero.positionY});
                positions.add(new int[]{(int)this.hero.positionX + 2, (int)this.hero.positionY});
                positions.add(new int[]{(int)this.hero.positionX - 1, (int)this.hero.positionY});
                positions.add(new int[]{(int)this.hero.positionX - 2, (int)this.hero.positionY});
                for (int[] p : positions) {
                    if (!this.isValidSlot(p[0], p[1])) continue;
                    Cosmetic spark = new Cosmetic("obj_silence_spark.png");
                    spark.setPosition(new float[]{p[0], p[1]});
                    spark.timer = 0.2f;
                    this.cosmetics.add(spark);
                    Element e = this.getElementAt(p[0], p[1]);
                    if (!(e instanceof Enemy)) continue;
                    ((Enemy)e).takeHit(1);
                    ((Enemy)e).deathrattleAvailable = false;
                }
            } else if (keyChar == 'R' && this.hero.transformAvailable) {
                success = true;
                this.hero.currentForm = 1;
                this.hero.beastQAvailable = true;
                this.hero.beastWAvailable = true;
                this.hero.beastEAvailable = true;
                this.hero.setImage("hero_beast.png");
                this.hero.transformAvailable = false;
            }
            if (usedMana && this.hero.hasItemOfType(Item.ItemType.ItemStaff)) {
                ++this.hero.tempAD;
            }
        } else if (this.hero.currentForm == 1) {
            if (keyChar == 'Q' && this.hero.beastQAvailable) {
                success = true;
                this.hero.attackIDs.add(0, "Q");
                this.hero.attackIDs.add(0, "Q");
                this.hero.beastQAvailable = false;
            } else if (keyChar == 'W' && this.hero.beastWAvailable) {
                success = true;
                this.hero.attackIDs.add(0, "W");
                this.hero.beastWAvailable = false;
            } else if (keyChar == 'E' && this.hero.beastEAvailable) {
                success = true;
                this.hero.attackIDs.add(0, "E");
                this.hero.beastEAvailable = false;
            } else if (keyChar == 'R' && this.hero.transformAvailable) {
                success = true;
                this.hero.currentForm = 0;
                this.hero.setImage("hero_druid.png");
                this.hero.transformAvailable = false;
                this.hero.attackIDs.clear();
            }
        }
        if (success && this.hero.lives == 1 && this.hero.hasItemOfType(Item.ItemType.ItemRedTalisman)) {
            this.hero.score += 2;
        }
        this.blockTime = blockTime = 0.25f;
    }

    public void enterPressed() {
        if (this.passTurnAfterDialogue) {
            this.blocked = false;
            this.passTurn(0.16f, 0.16f);
        }
        if (this.dialogue.visible) {
            this.dialogue.visible = false;
            Item item = this.dialogue.items.get(this.dialogue.selectedItem);
            if (item.isImmediate()) {
                switch (item.type) {
                    case ItemHeal: {
                        this.hero.addLife(1);
                        break;
                    }
                    case ItemEnergize: {
                        this.hero.addMana(2);
                        break;
                    }
                    case ItemScore: {
                        ++this.hero.score;
                        break;
                    }
                    case ItemAttack: {
                        this.hero.tempAD = 2;
                        break;
                    }
                    case ItemMaxStar: {
                        this.hero.addLife(5);
                        this.hero.addMana(5);
                        this.hero.score += 20;
                        break;
                    }
                }
            } else {
                this.hero.items.add(item);
                if (item.type == Item.ItemType.ItemBlueTalisman) {
                    this.hero.addMana(0);
                } else if (item.type == Item.ItemType.ItemVampiricNecklace) {
                    this.hero.lives = Math.min(3, this.hero.lives);
                }
            }
        }
    }

    private void passTurn(float blockTime, float waitTime) {
        this.enemyTurnTimer = waitTime;
        this.blockTime = blockTime;
        if (this.hero.silenceCounter > 0) {
            --this.hero.silenceCounter;
        }
        for (ScoreSoul s : this.souls) {
            --s.lives;
        }
    }

    private void startEnemyTurn() {
        this.checkTrap(true);
        if (this.enemies.size() >= 4 && this.hero.hasItemOfType(Item.ItemType.ItemSoulStealer)) {
            this.hero.addMana(1);
        }
    }

    private void checkTrap(boolean shouldActivate) {
        if (this.hero.nextPosX == this.trap.positionX && this.hero.nextPosY == this.trap.positionY) {
            if (this.trap.state == 0) {
                this.trap.state = 1;
                this.trap.setImage("obj_trap_down.png");
            } else if (this.trap.state == 1 && shouldActivate) {
                this.trap.state = 2;
                this.hitHero("Trap");
                Cosmetic trapActive = new Cosmetic("obj_trap_up.png");
                trapActive.drawDeltaY = 29;
                trapActive.setPosition(this.trap.getPosition());
                trapActive.timer = 0.3f;
                this.cosmetics.add(trapActive);
                this.trap.setImage("obj_trap_gone.png");
            }
        }
    }

    private void advanceLevel() {
        Enemy e;
        ++this.currentLevel;
        this.enemiesDidMove = false;
        if (this.currentLevel > 10) {
            return;
        }
        this.projectiles.clear();
        this.statics.clear();
        this.enemies.clear();
        this.souls.clear();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.tileColor[i][j] = (int)Math.floor(Math.random() * 5.0);
                ++j;
            }
            ++i;
        }
        this.randomizeHeroAndPortal();
        this.hero.ad = 1;
        this.hero.silenceCounter = 0;
        this.hero.invulnerable = false;
        this.passTurnAfterDialogue = false;
        this.secretLevel = false;
        this.chestIsFromSecretLevel = false;
        this.trap = new Trap();
        int[] trapPos = this.getRandomEmptySlot();
        this.trap.setPosition(new float[]{trapPos[0], trapPos[1]});
        this.dialogue.items = new ArrayList();
        ArrayList<Item.ItemType> itemTypes = WaveManager.getSharedManager().getItems(this.currentLevel - 1);
        for (Item.ItemType type : itemTypes) {
            this.dialogue.items.add(new Item(type));
        }
        Map<String, Integer> enemies = WaveManager.getSharedManager().getEnemies(this.currentLevel - 1);
        int n = enemies.get("objEnemyTreefolk");
        int i2 = 0;
        while (i2 < n) {
            e = Enemy.getEnemy(this, Enemy.EnemyType.Treefolk);
            e.teleportTo(this.getRandomEmptySlot());
            this.enemies.add(e);
            ++i2;
        }
        n = enemies.get("objEnemyOoze");
        i2 = 0;
        while (i2 < n) {
            e = Enemy.getEnemy(this, Enemy.EnemyType.Ooze);
            e.teleportTo(this.getRandomEmptySlot());
            this.enemies.add(e);
            ++i2;
        }
        n = enemies.get("objEnemyShroom");
        i2 = 0;
        while (i2 < n) {
            e = Enemy.getEnemy(this, Enemy.EnemyType.Shroom);
            e.teleportTo(this.getRandomEmptySlot());
            this.enemies.add(e);
            ++i2;
        }
        n = enemies.get("objEnemySnail");
        i2 = 0;
        while (i2 < n) {
            e = Enemy.getEnemy(this, Enemy.EnemyType.Snail);
            e.teleportTo(this.getRandomEmptySlot());
            this.enemies.add(e);
            ++i2;
        }
        n = enemies.get("objEnemyChest");
        i2 = 0;
        while (i2 < n) {
            e = Enemy.getEnemy(this, Enemy.EnemyType.Chest);
            e.teleportTo(this.getRandomEmptySlot());
            this.enemies.add(e);
            ++i2;
        }
        n = enemies.get("objEnemySuperChest");
        i2 = 0;
        while (i2 < n) {
            e = Enemy.getEnemy(this, Enemy.EnemyType.Chest);
            e.teleportTo(this.getRandomEmptySlot());
            e.lives = 5;
            this.enemies.add(e);
            ++i2;
        }
        this.randomizeMark();
        this.boardDeltaY = -600;
        this.advanceLevelStatus = 2;
    }

    private ArrayList<Enemy> getAdjacentEnemies(int x, int y) {
        Element e;
        ArrayList<Enemy> list = new ArrayList<Enemy>();
        if (x > 0 && (e = this.getElementAt(x - 1, y)) instanceof Enemy) {
            list.add((Enemy)e);
        }
        if (x < 2 && (e = this.getElementAt(x + 1, y)) instanceof Enemy) {
            list.add((Enemy)e);
        }
        if (y > 0 && (e = this.getElementAt(x, y - 1)) instanceof Enemy) {
            list.add((Enemy)e);
        }
        if (y < 2 && (e = this.getElementAt(x, y + 1)) instanceof Enemy) {
            list.add((Enemy)e);
        }
        return list;
    }

    private void throwDagger() {
        Enemy target = this.daggerTargets.get(0);
        this.daggerTargets.remove(0);
        Projectile dagger = new Projectile(Projectile.ProjectileType.DarkDagger, true, target);
        dagger.setPosition(this.hero.getPosition());
        this.projectiles.add(dagger);
    }

    private void randomizeMark() {
        int bestCount = 0;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int count;
                if (this.getElementAt(i, j) == null && (this.hero.getSlot()[0] != i || this.hero.getSlot()[1] != j) && (count = this.getAdjacentEnemies(i, j).size()) > bestCount) {
                    bestCount = count;
                }
                ++j;
            }
            ++i;
        }
        ArrayList<int[]> candidates = new ArrayList<int[]>();
        int i2 = 0;
        while (i2 < 3) {
            int j = 0;
            while (j < 3) {
                int count;
                if (this.getElementAt(i2, j) == null && (this.hero.getSlot()[0] != i2 || this.hero.getSlot()[1] != j) && (count = this.getAdjacentEnemies(i2, j).size()) == bestCount) {
                    candidates.add(new int[]{i2, j});
                }
                ++j;
            }
            ++i2;
        }
        this.markPosition = (int[])candidates.get((int)(Math.random() * (double)candidates.size()));
    }

    private void randomizeHeroAndPortal() {
        this.hero.teleportTo(new int[]{(int)Math.floor(Math.random() * 3.0), 2});
        this.portal.setPosition(new float[]{(int)Math.floor(Math.random() * 3.0), -1.0f});
    }

    private int[] getRandomEmptySlot(ArrayList<int[]> slotSet) {
        ArrayList allSlots = (ArrayList)slotSet.clone();
        ArrayList<int[]> toRemove = new ArrayList<int[]>();
        for (int[] slot : allSlots) {
            if (this.getElementAt(slot[0], slot[1]) != null) {
                toRemove.add(slot);
                continue;
            }
            if (this.hero.getSlot()[0] != slot[0] || this.hero.getSlot()[1] != slot[1]) continue;
            toRemove.add(slot);
        }
        for (int[] slot : toRemove) {
            allSlots.remove(slot);
        }
        return (int[])allSlots.get((int)Math.floor(Math.random() * (double)allSlots.size()));
    }

    private int[] getRandomEmptySlot() {
        return this.getRandomEmptySlot(this.allSlots);
    }

    @Override
    public Element getElementAt(int x, int y) {
        for (Element element : this.enemies) {
            if (element.getSlot()[0] != x || element.getSlot()[1] != y) continue;
            return element;
        }
        for (Element element : this.statics) {
            if (element.getSlot()[0] != x || element.getSlot()[1] != y) continue;
            return element;
        }
        return null;
    }

    private boolean isValidSlot(float x, float y) {
        return x >= 0.0f && x <= 2.0f && y >= 0.0f && y <= 2.0f;
    }

    public String getDescriptionAt(int x, int y) {
        Element e = this.getElementAt(x, y);
        if (e != null) {
            return e.getDescription();
        }
        if (this.portal.getPosition()[0] == (float)x && this.portal.getPosition()[1] == (float)y) {
            return "Go to next level";
        }
        ArrayList<ScoreSoul> souls = this.getSoulsAt(x, y);
        if (souls.size() > 0) {
            return String.valueOf(souls.size()) + " score souls";
        }
        if (this.currentLevel == 7 && x == 2 && y == 2) {
            return "He who frees all souls in one turn, will be rewarded";
        }
        return null;
    }

    public ArrayList<DSprite> getSprites() {
        ArrayList<DSprite> sprites = new ArrayList<DSprite>();
        sprites.addAll(this.souls);
        sprites.add(this.portal);
        sprites.addAll(this.statics);
        sprites.addAll(this.enemies);
        sprites.add(this.hero);
        if (this.trap.state != 0 || this.hero.hasItemOfType(Item.ItemType.ItemTruesightWard)) {
            sprites.add(this.trap);
        }
        sprites.addAll(this.projectiles);
        sprites.addAll(this.cosmetics);
        return sprites;
    }

    public int getLevel() {
        return this.currentLevel;
    }

    @Override
    public Hero getHero() {
        return this.hero;
    }

    @Override
    public boolean isSlotAvailable(int x, int y) {
        Element e = this.getElementAt(x, y);
        return e == null || e.type != Element.ElementType.kTypeEnemy;
    }

    @Override
    public void elementMoving(int[] fromPos, int[] toPos) {
    }

    @Override
    public void hitHero(String threatName) {
        if (this.hero.invulnerable) {
            return;
        }
        if (this.hero.shields > 0) {
            --this.hero.shields;
        } else {
            ++this.hero.hitsTakenThisTurn;
            if (this.hero.hitsTakenThisTurn == 2 && this.hero.hasItemOfType(Item.ItemType.ItemWizardRing)) {
                this.hero.addMana(8);
            }
            if (this.hero.hpLostThisTurn <= 0 || !this.hero.hasItemOfType(Item.ItemType.ItemDodge)) {
                ++this.hero.hpLostThisTurn;
                this.hero.lives = Math.max(0, this.hero.lives - 1);
            }
            if (this.hero.lives <= 0) {
                this.killer = threatName;
            }
        }
        SoundManager.getSharedManager().playSound("hit.wav");
    }

    @Override
    public void addProjectile(Projectile p) {
        this.projectiles.add(p);
    }

    public int getBoardY() {
        return this.boardDeltaY;
    }

    public void checkSecretLevel() {
        if (this.currentLevel == 7 && this.enemies.size() == 0 && !this.enemiesDidMove) {
            this.secretLevel = true;
            Enemy e = Enemy.getEnemy(this, Enemy.EnemyType.Ooze);
            e.teleportTo(this.getRandomEmptySlot());
            e.lives = 3;
            this.enemies.add(e);
            e = Enemy.getEnemy(this, Enemy.EnemyType.Shroom);
            e.teleportTo(this.getRandomEmptySlot());
            e.lives = 3;
            this.enemies.add(e);
            e = Enemy.getEnemy(this, Enemy.EnemyType.Snail);
            e.teleportTo(this.getRandomEmptySlot());
            e.lives = 3;
            this.enemies.add(e);
            e = Enemy.getEnemy(this, Enemy.EnemyType.Chest);
            e.teleportTo(this.getRandomEmptySlot());
            e.lives = 3;
            this.enemies.add(e);
            this.enemyTurnTimer = -1.0f;
            this.passTurnAfterDialogue = false;
            this.randomizeMark();
        }
    }
}

