/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import roguelike.ColorManager;
import roguelike.Element;
import roguelike.Enemy;
import roguelike.Global;
import roguelike.MapManager;

public class EnemyQuick
extends Enemy {
    private boolean sleeping;

    public EnemyQuick(MapManager map) {
        super(map);
        this.name = "EnemyQuickZ";
        this.colorModel = ColorManager.getSharedManager().getColorModel("EnemyQuickZ");
        this.sleeping = true;
        this.velocity *= 2.0f;
    }

    @Override
    public void move() {
        if (this.sleeping) {
            if (this.stunCount > 0) {
                this.updateCooldowns();
                return;
            }
            int dir = -1;
            if (this.map.getHero().getSlot()[0] == this.getSlot()[0]) {
                if (this.map.getHero().getSlot()[1] > this.getSlot()[1]) {
                    dir = 2;
                } else if (this.map.getHero().getSlot()[1] < this.getSlot()[1]) {
                    dir = 0;
                }
            } else if (this.map.getHero().getSlot()[1] == this.getSlot()[1]) {
                if (this.map.getHero().getSlot()[0] > this.getSlot()[0]) {
                    dir = 1;
                } else if (this.map.getHero().getSlot()[0] < this.getSlot()[0]) {
                    dir = 3;
                }
            }
            if (dir >= 0) {
                int i = 0;
                while (i < 8) {
                    Element e = this.map.getElementAt(this.getSlot()[0] + (float)i * Global.getVectorFromDir(dir)[0], this.getSlot()[1] + (float)i * Global.getVectorFromDir(dir)[1]);
                    if (this.getSlot()[0] + (float)i * Global.getVectorFromDir(dir)[0] == this.map.getHero().getSlot()[0] && this.getSlot()[1] + (float)i * Global.getVectorFromDir(dir)[1] == this.map.getHero().getSlot()[1]) {
                        this.sleeping = false;
                        this.colorModel = ColorManager.getSharedManager().getColorModel("EnemyQuickL");
                        this.name = "EnemyQuickL";
                        break;
                    }
                    if (e != null && e.getType() == Element.ElementType.kTypeWall) break;
                    ++i;
                }
            }
            return;
        }
        int prevStun = this.stunCount;
        super.move();
        if (this.nextPosX > this.positionX) {
            this.name = "EnemyQuickR";
            this.colorModel = ColorManager.getSharedManager().getColorModel("EnemyQuickR");
        } else if (this.nextPosX < this.positionX) {
            this.name = "EnemyQuickL";
            this.colorModel = ColorManager.getSharedManager().getColorModel("EnemyQuickL");
        }
        if (this.tackleDestination == null && prevStun <= 0) {
            super.move();
        }
    }
}

