/*
 * Decompiled with CFR 0.152.
 */
package roguelike;

import java.awt.Color;

public class MagicTile {
    protected float positionX;
    protected float positionY;
    private int sweepIndex;
    private float sweepTimer;
    private float removeTimer;
    private boolean shouldRemove;
    private Color color;
    private TileType type;

    public MagicTile(TileType type, float[] pos, boolean sweepEffect) {
        this.type = type;
        this.positionX = pos[0];
        this.positionY = pos[1];
        this.color = MagicTile.getColorByType(type);
        if (sweepEffect) {
            this.sweepIndex = 0;
            this.sweepTimer = 0.001f;
        } else {
            this.sweepIndex = -1;
            this.sweepTimer = 0.0f;
        }
    }

    public void update(float dt) {
        if (this.sweepIndex >= 0) {
            this.sweepTimer -= dt;
            if (this.sweepTimer < 0.0f) {
                ++this.sweepIndex;
                this.sweepTimer = 0.02f;
                if (this.sweepIndex > 14) {
                    this.sweepIndex = -1;
                    this.sweepTimer = -1.0f;
                }
            }
        }
        if (this.removeTimer > 0.0f) {
            this.removeTimer -= dt;
            if (this.removeTimer <= 0.0f) {
                this.shouldRemove = true;
            }
        }
    }

    public float[] getSlot() {
        return new float[]{this.positionX, this.positionY};
    }

    public int getSweepIndex() {
        return this.sweepIndex;
    }

    public Color getColor() {
        return this.color;
    }

    public TileType getType() {
        return this.type;
    }

    public String getDescription() {
        String retVal = "";
        switch (this.type) {
            case Fireball: {
                retVal = "Fireball: cast then chose direction.";
                break;
            }
            case OffensiveStance: {
                retVal = "Combat Stance: tackle to attack (2 uses).";
                break;
            }
            case Lightning: {
                retVal = "Lightning: damage tiles around you.";
                break;
            }
            case DefensiveStance: {
                retVal = "Def Stance: block attacks (3 uses).";
                break;
            }
            case Shield: {
                retVal = "Shield: block next attack.";
                break;
            }
            case Teleport: {
                retVal = "Teleport: to another purple slot.";
                break;
            }
            case QuickStance: {
                retVal = "Quick Stance: move two tiles (4 uses).";
                break;
            }
            case Freeze: {
                retVal = "Freeze: freeze enemies for 4 turns.";
                break;
            }
            case Dash: {
                retVal = "Dash: cast then choose direction to dash.";
                break;
            }
            case Used: {
                retVal = "Used Tile.";
                break;
            }
            default: {
                retVal = "Woops.";
            }
        }
        return retVal;
    }

    public int getCost() {
        return 0;
    }

    public static Color getColorByType(TileType type) {
        switch (type) {
            case Fireball: {
                return new Color(250, 115, 50);
            }
            case OffensiveStance: {
                return new Color(190, 60, 65);
            }
            case Lightning: {
                return new Color(255, 192, 0);
            }
            case DefensiveStance: {
                return new Color(30, 138, 74);
            }
            case Shield: {
                return new Color(134, 97, 47);
            }
            case Teleport: {
                return new Color(160, 97, 193);
            }
            case QuickStance: {
                return new Color(190, 34, 140);
            }
            case Freeze: {
                return new Color(70, 183, 183);
            }
            case Dash: {
                return new Color(65, 80, 170);
            }
            case Used: {
                return new Color(200, 200, 200);
            }
        }
        return new Color(255, 255, 255);
    }

    public void startRemoval() {
        this.removeTimer = 0.75f;
    }

    public boolean shouldRemove() {
        return this.shouldRemove;
    }

    public static enum TileType {
        Fireball,
        OffensiveStance,
        Lightning,
        DefensiveStance,
        Shield,
        Teleport,
        QuickStance,
        Freeze,
        Dash,
        Used;

    }
}

